package inc.monsters.mias.data;

import java.util.ArrayList;
import java.util.List;

public class FoodList {
	List<String> list;
	
	public FoodList() {
		this.list = new ArrayList<String>();
	}
	
	public void add(String food) {
		list.add(food);
	}
	
	public List<String> getAsList() {
		return list;
	}
	
	public String toString() {
		return toStringWithSeparator(" ");
	}
	
	public String toStringWithSeparator(String separator) {
		StringBuilder sb = new StringBuilder();
		for(String food : list) {
			sb.append(separator); // separator
			sb.append(food);
		}
		if (sb.length() > 0) {
			// Use substring to remove leading separator
			return sb.toString().substring(separator.length()); 
		} else {
			return "";
		}		
	}
}
